import numpy as np
from matplotlib import pyplot as plt

# kreiramo podatke
x = np.linspace(0, 3*np.pi, 1000)
sin_x = np.sin(x)
cos_x = np.cos(x)
log_x = np.log(x)
exp_x = np.exp(x)

plt.figure(1)

# drugi nacin za crtanje subplot-ova
# potrebno je da kao argumente funkcije navedemo broj crteza
# duz x i y ose uz redni broj crteza koji trenutno crtamo
# redni brojevi crteza krecu od 1 i brojeve se s leva na desno
# odozgo na dole
plt.subplot(2,2,1)
plt.plot(x, sin_x)
# podesavanja se primenjuju odvojeno na svaki grafik
plt.title("Sin_x")
plt.xlabel("x")
plt.ylabel("sin(x)")
plt.grid()

plt.subplot(2,2,2)
plt.plot(x, cos_x)
plt.title("Cos_x")
plt.xlabel("x")
plt.ylabel("cos(x)")
plt.grid()

plt.subplot(2,2,3)
plt.plot(x, log_x)
plt.title("Log_x")
plt.xlabel("x")
plt.ylabel("log(x)")
plt.grid()

plt.subplot(2,2,4)
plt.plot(x, exp_x)
plt.title("Exp_x")
plt.xlabel("x")
plt.ylabel("exp(x)")
plt.grid()

plt.tight_layout()
plt.show()